/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.models.entities;

import com.alexander.mutantmore.entities.Rodling;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedTickingGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class RodlingModel
extends AnimatedTickingGeoModel<Rodling> {
    public ResourceLocation getAnimationResource(Rodling entity) {
        return new ResourceLocation("mutantmore", "animations/rodling.animation.json");
    }

    public ResourceLocation getModelResource(Rodling entity) {
        return new ResourceLocation("mutantmore", "geo/rodling.geo.json");
    }

    public ResourceLocation getTextureResource(Rodling entity) {
        if (entity.isSoul()) {
            return !entity.m_21824_() ? new ResourceLocation("mutantmore", "textures/entities/soul_rodling_hostile.png") : new ResourceLocation("mutantmore", "textures/entities/soul_rodling.png");
        }
        return !entity.m_21824_() ? new ResourceLocation("mutantmore", "textures/entities/rodling_hostile.png") : new ResourceLocation("mutantmore", "textures/entities/rodling.png");
    }

    public void setLivingAnimations(Rodling entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone rod1 = this.getAnimationProcessor().getBone("rod1");
        IBone rod2 = this.getAnimationProcessor().getBone("rod2");
        IBone shield1 = this.getAnimationProcessor().getBone("shield1");
        IBone shield2 = this.getAnimationProcessor().getBone("shield2");
        IBone headArmour = this.getAnimationProcessor().getBone("headArmour");
        IBone rodArmour = this.getAnimationProcessor().getBone("rodArmour");
        IBone shieldArmour = this.getAnimationProcessor().getBone("shieldArmour");
        IBone rodArmour2 = this.getAnimationProcessor().getBone("rodArmour2");
        IBone shieldArmour2 = this.getAnimationProcessor().getBone("shieldArmour2");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (entity.isArmoured()) {
            headArmour.setHidden(false);
            rodArmour.setHidden(false);
            shieldArmour.setHidden(false);
            rodArmour2.setHidden(false);
            shieldArmour2.setHidden(false);
        } else {
            headArmour.setHidden(true);
            rodArmour.setHidden(true);
            shieldArmour.setHidden(true);
            rodArmour2.setHidden(true);
            shieldArmour2.setHidden(true);
        }
        if (entity.hasShields()) {
            shield1.setHidden(false);
            shield2.setHidden(false);
            rod1.setHidden(true);
            rod2.setHidden(true);
            if (entity.getShields() == 2) {
                shield1.setHidden(false);
                shield2.setHidden(false);
            } else if (entity.getShields() == 1) {
                shield1.setHidden(false);
                shield2.setHidden(true);
            } else if (entity.getShields() <= 0) {
                shield1.setHidden(true);
                shield2.setHidden(true);
            }
        } else {
            shield1.setHidden(true);
            shield2.setHidden(true);
            rod1.setHidden(false);
            rod2.setHidden(false);
        }
        if (Minecraft.m_91087_().m_91104_()) {
            if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
                head.setRotationX(head.getRotationX());
                head.setRotationY(head.getRotationY());
            }
        } else if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * (float)Math.PI / 180.0f);
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * (float)Math.PI / 180.0f);
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        LivingEntity livingEntity = (LivingEntity)animatable;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        parser.setValue("query.ground_speed", (double)groundSpeed * 7.5);
    }
}

